/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.designer;

import filenet.vw.apps.designer.VWDesignerCore;
import filenet.vw.apps.designer.resources.VWResource;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.IVWSplashWindowListener;
import filenet.vw.toolkit.utils.VWBaseAppLauncherApplet;
import filenet.vw.toolkit.utils.VWSplashWindow;
import filenet.vw.toolkit.utils.VWStringUtils;

public class VWDesignerApplet
extends VWBaseAppLauncherApplet
implements IVWSplashWindowListener {
    private VWSplashWindow m_splashWindow = null;
    private VWDesignerCore m_designerCore = null;

    public void init() {
        try {
            super.init();
            this.m_splashWindow = new VWSplashWindow(null);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void start() {
        if (this.m_splashWindow != null) {
            this.m_splashWindow.start(this, 1000);
        }
    }

    public void destroy() {
        try {
            if (this.m_designerCore != null && this.isActive()) {
                this.m_designerCore.windowClosing(null);
            }
            super.destroy();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void startProcessing() {
        try {
            String[] groups = new String[]{VWResource.s_pwDesignerGroup, VWResource.s_pwDiagramGroup};
            if (!this.m_sessionInfo.verifyLogon(groups, false)) {
                this.abort();
                return;
            }
            int nApplicationMode = 1;
            if (VWStringUtils.compare(this.m_sessionInfo.getSecurityGroupName(), VWResource.s_pwDiagramGroup) == 0) {
                nApplicationMode = 0;
            }
            if (this.m_splashWindow != null) {
                this.m_splashWindow.setVisible(true);
            }
            this.m_designerCore = new VWDesignerCore();
            this.m_designerCore.init(this.m_sessionInfo, nApplicationMode);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

